//=============================================================================
// ThighPads.
//=============================================================================
class xmasThighPads extends ThighPads;

#exec mesh import mesh=XmasDrum anivfile=Models\XmasDrum_a.3d datafile=Models\XmasDrum_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=XmasDrum x=0 y=0 z=0
#exec mesh sequence mesh=XmasDrum seq=All startframe=0 numframes=1

#exec meshmap new meshmap=XmasDrum mesh=XmasDrum
#exec meshmap scale meshmap=XmasDrum x=0.07813 y=0.07813 z=0.15625

#exec AUDIO IMPORT FILE="Sounds\xmasDrum.WAV" NAME="xmasDrum"

function bool HandlePickupQuery( inventory Item )
{
	local inventory S;

	if ( item.class == class ) 
	{
		S = Pawn(Owner).FindInventoryType(class'UT_Shieldbelt');	
		if (  S==None )
		{
			if ( Charge<Item.Charge )	
				Charge = Item.Charge;
		}
		else
			Charge = Clamp(S.Default.Charge - S.Charge, Charge, Item.Charge );
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);
	S = Other.FindInventoryType(class'UT_Shieldbelt');	
	if ( S != None )
	{
		Copy.Charge = Min(Copy.Charge, S.Default.Charge - S.Charge);
		if ( Copy.Charge <= 0 )
		{ 
			S.Charge -= 1;
			Copy.Charge = 1;
		}
	}
	return Copy;
}

defaultproperties
{
     PickupMessage="You got a Xmas drum!"
     ItemName="Xmas drum"
     PickupViewMesh=Mesh'DanesXmas_v2009.XmasDrum'
     PickupSound=Sound'DanesXmas_v2009.XmasDrum'
     Mesh=Mesh'DanesXmas_v2009.XmasDrum'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'DanesXmas_v2009.DrumDeco1'
     MultiSkins(1)=Texture'DanesXmas_v2009.InvisDeco'
     MultiSkins(2)=Texture'DanesXmas_v2009.DrumDeco2'
     CollisionRadius=12.000000
     CollisionHeight=20.000000
}
